/*
 * Decompiled with CFR 0.152.
 */
package com.github;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import anywheresoftware.b4a.BA;
import com.github.PermissionCallback;
import com.github.PermissionListener;
import com.github.PermissionRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class Nammu {
    private static SharedPreferences sharedPreferences;
    private static final String KEY_PREV_PERMISSIONS = "previous_permissions";
    private static ArrayList<PermissionRequest> permissionRequests;
    private final BA ba;

    public Nammu(BA bA) {
        this.ba = bA;
        Nammu.init(bA.context);
    }

    public static void init(Context context) {
        sharedPreferences = context.getSharedPreferences("pl.tajchert.runtimepermissionhelper", 0);
    }

    public static boolean verifyPermissions(int[] nArray) {
        for (int n : nArray) {
            if (n == 0) continue;
            return false;
        }
        return true;
    }

    public boolean hasPermission(Activity activity, String string) {
        if (!Nammu.isMNC()) {
            return true;
        }
        return activity.checkSelfPermission(string) == 0;
    }

    public static boolean hasPermission(Activity activity, String[] stringArray) {
        if (!Nammu.isMNC()) {
            return true;
        }
        for (String string : stringArray) {
            if (activity.checkSelfPermission(string) == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isMNC() {
        return Build.VERSION.SDK_INT == 23;
    }

    public static void askForPermission(Activity activity, String string, PermissionCallback permissionCallback) {
        Nammu.askForPermission(activity, new String[]{string}, permissionCallback);
    }

    public static void askForPermission(Activity activity, String[] stringArray, PermissionCallback permissionCallback) {
        if (permissionCallback == null) {
            return;
        }
        if (Nammu.hasPermission(activity, stringArray)) {
            permissionCallback.permissionGranted();
            return;
        }
        PermissionRequest permissionRequest = new PermissionRequest(new ArrayList<String>(Arrays.asList(stringArray)), permissionCallback);
        permissionRequests.add(permissionRequest);
        activity.requestPermissions(stringArray, permissionRequest.getRequestCode());
    }

    public static void onRequestPermissionsResult(int n, String[] stringArray, int[] nArray) {
        PermissionRequest permissionRequest = new PermissionRequest(n);
        if (permissionRequests.contains(permissionRequest)) {
            PermissionRequest permissionRequest2 = permissionRequests.get(permissionRequests.indexOf(permissionRequest));
            if (Nammu.verifyPermissions(nArray)) {
                permissionRequest2.getPermissionCallback().permissionGranted();
            } else {
                permissionRequest2.getPermissionCallback().permissionRefused();
            }
            permissionRequests.remove(permissionRequest);
        }
    }

    public static void savePermission(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : stringArray) {
            hashSet.add(string);
        }
        hashSet.addAll(Nammu.getPrevPermissions());
        sharedPreferences.edit().putStringSet(KEY_PREV_PERMISSIONS, hashSet).apply();
    }

    public static void savePermission(ArrayList<String> arrayList) {
        if (arrayList == null) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(arrayList);
        hashSet.addAll(Nammu.getPrevPermissions());
        sharedPreferences.edit().putStringSet(KEY_PREV_PERMISSIONS, hashSet).apply();
    }

    public static void savePermission(String string) {
        if (string == null) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        hashSet.addAll(Nammu.getPrevPermissions());
        sharedPreferences.edit().putStringSet(KEY_PREV_PERMISSIONS, hashSet).apply();
    }

    public static ArrayList<String> getPrevPermissions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(sharedPreferences.getStringSet(KEY_PREV_PERMISSIONS, new HashSet()));
        return arrayList;
    }

    public static boolean containsPermission(String string) {
        if (string == null) {
            return false;
        }
        return Nammu.getPrevPermissions().contains(string);
    }

    public static void removePermission(String string) {
        if (Nammu.containsPermission(string)) {
            ArrayList<String> arrayList = Nammu.getPrevPermissions();
            arrayList.remove(string);
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(arrayList);
            sharedPreferences.edit().putStringSet(KEY_PREV_PERMISSIONS, hashSet).apply();
        }
    }

    public static void permissionCompare(Activity activity, PermissionListener permissionListener) {
        if (activity == null) {
            return;
        }
        ArrayList<String> arrayList = Nammu.getPrevPermissions();
        for (String string : arrayList) {
            if (activity.checkSelfPermission(string) == 0) continue;
            if (permissionListener != null) {
                permissionListener.permissionsChanged(string);
            }
            Nammu.removePermission(string);
        }
    }

    static {
        permissionRequests = new ArrayList();
    }
}

